#ifndef __CCenterSlider__
#define __CCenterSlider__

#include "CControl.hpp"
#include "CRolloverButton.hpp"
#include <MathTools/CBounds.hpp>

//	===========================================================================

using Exponent::GUI::Controls::CControl;
using Exponent::GUI::Controls::CRolloverButton;
using Exponent::MathTools::CBounds;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CCenterSlider CCenterSlider.hpp
			 * @brief A slider that goes is center detented grpahically around 0.5 - internal value still goes from 0.0 - 1.0
			 *
			 * @date 17/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CCenterSlider.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CCenterSlider : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CCenterSlider(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CCenterSlider();

//	===========================================================================

				/**
				 * Set the value (scaled 0 - 1
				 * @param value The value of the slider
				 */
				virtual void setValue(const double value);

				/**
				 * Set the colours
				 * @param frameColour The colour of the outer frame
				 * @param backgroundColour The background colour
				 * @param handleColour The colour of the handle the user can grab
				 * @param handleOverColour The colour of the handle the user can grab when the mouse is over it
				 * @param handleDownColour The colour of the handle the user can grab when the mouse has grabbed it
				 */
				virtual void setColours(CAlphaColour frameColour, CAlphaColour backgroundColour, CAlphaColour handleColour, CAlphaColour handleOverColour, CAlphaColour handleDownColour);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the scroll wheel
				 * @param event The event to handle
				 */
				virtual void handleMouseScroll(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * Handle movement
				 * @param event The event to handle movement from
				 */
				void handleMovement(CMouseEvent &event);

//	===========================================================================

				long  m_centerPoint;						/**< The center point of this control */

				CAlphaColour m_handleColour;				/**< Colour of the slider */
				CAlphaColour m_handleOverColour;			/**< Colour of the slider when mouse is over */
				CAlphaColour m_handleDownColour;			/**< Colour of the slider when mouse is down */

				CRolloverButton::ERolloverState m_state;	/**< Current state of slider (0 = off : 1 = over : 2 = on) */

				CRect m_sliderArea;							/**< The area of the slider */

				bool m_isVertical;							/**< Is the slider vertical? */
				bool m_isDragging;							/**< Is the user dragging? */
			};
		}
	}
}
#endif	// End of CCenterSlider.hpp